<?php

use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\Admin\LoginController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\ShipmentController;
use App\Http\Controllers\Admin\TrackingController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Pages\ContactController;
use App\Http\Controllers\Pages\PageController;
use App\Http\Controllers\Pages\TrackingController as PagesTrackingController; 

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('pages.index');
})->name('home');

Route::get('/admin/login', [LoginController::class, 'login'])->middleware('guest')->name('login');
Route::get('/admin/reset-password', [LoginController::class, 'reset'])->middleware('guest')->name('reset-password');

Route::group(['prefix' => 'admin', 'middleware' => 'auth'], function () {
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    //Shipment
    Route::get('/shipments', [ShipmentController::class, 'all'])->name('shipments');
    Route::name('shipment.')->prefix('shipment')->group(function () {
        Route::get('/create', [ShipmentController::class, 'create'])->name('create');
        Route::get('/{shipment:tracking_code}/edit', [ShipmentController::class, 'edit'])->name('edit');
        Route::get('/{shipment:tracking_code}', [ShipmentController::class, 'single'])->name('single');
        Route::delete('/{shipment}', [ShipmentController::class, 'delete'])->name('delete');
    });

    //Invoice
    Route::get('/{shipment:tracking_code}/invoice', [InvoiceController::class, 'stream'])->name('invoice.stream');
    Route::get('/{shipment:tracking_code}/download', [InvoiceController::class, 'download'])->name('invoice.download');

    //Tracking
    Route::get('/trackings', [TrackingController::class, 'all'])->name('trackings');
    Route::name('tracking.')->prefix('tracking')->group(function () {
        Route::get('/{tracking}', [TrackingController::class, 'single'])->name('single');
        Route::get('/{tracking}/edit', [TrackingController::class, 'edit'])->name('edit');
        Route::delete('/{tracking}', [TrackingController::class, 'delete'])->name('delete');
    });

    //Settings and Config
    Route::get('/settings', [SettingsController::class, 'general'])->name('settings.general');
    Route::get('/config', [SettingsController::class, 'config'])->name('settings.config');

    //Profile
    Route::get('/profile', [ProfileController::class, 'index'])->name('profile');

    //Notice
    Route::post('/send-notice', [ContactController::class, 'send_notice'])->name('send-notice');

    //Contact Messages
    Route::get('/contact-messages', [ContactController::class, 'contact_messages'])->name('contact-messages');
    Route::get('/contact-message/{contact}', [ContactController::class, 'single'])->name('contact-message.single');
    Route::delete('/contact/{contact}', [ContactController::class, 'delete'])->name('contact-message.delete');
});

//Track
Route::view('/tracking', 'pages.tracking.index')->name('tracking');
Route::post('/tracking', [PagesTrackingController::class, 'track'])->name('tracking.process');
Route::get('/track/details', [PagesTrackingController::class, 'details'])->name('tracking.details');

//Contact
Route::post('/contact', [ContactController::class, 'send'])->name('contact.send');

//Crude Installer
Route::get('/install', function () {
    Artisan::call('storage:link');
    
    return 'Storage Linked <br>Migrations run <br>Installed Successfully ';
});

//Other Pages
Route::get('/{page}', [PageController::class, 'show']);