<x-layouts.dashboard title="Tracking - {{ $shipment->tracking_code }}">
    <x-widgets.page-header title="Tracking - {{ $shipment->tracking_code }}">
        <div class="breadcrumb-item"><a href="javascript:void(0)"> Manage Trackings </a></div>
    </x-widgets.page-header>

    <div class="container">
        <div class="card">
            <div class="card-body">

                <div class="d-flex align-items-center justify-content-between">
                    <div class="logo">
                        <img alt="logo" class="img-fluid" src="{{ $settings->site_logo }}">
                    </div>
                    <div class="fw-bold">
                        <h5 class="mb-0">Tracking Code</h5>
                        <span>{{ $shipment->tracking_code }}</span> <i x-data class="icon-copy feather" role="button"
                            @click="$clipboard(@js($shipment->tracking_code), $el)"></i>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-md-6 mb-3">
                        <span>Date Sent</span>
                        <div class="mt-1 text-dark fw-bold">{{ $tracking->date_sent->format('d/m/Y') }}</div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <span>Expected Arrival Date</span>
                        <div class="mt-1 text-dark fw-bold">{{ $tracking->date_expected->format('d/m/Y') }}</div>
                    </div>
                </div>

                <div class="mt-5">
                    <h5>Tracking Details</h5>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Details</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Tracking Status</td>
                                <td>
                                    <div
                                        class="d-flex align-items-center text-{{ status_class($tracking->status_code) }}">
                                        <span
                                            class="badge-dot me-2 bg-{{ status_class($tracking->status_code) }}"></span>
                                        <span class="text-capitalize">{!! status($tracking->status_code) !!}</span>
                                    </div>
                                </td>
                            </tr>

                            @if ($tracking->status_code == 0)
                                <tr>
                                    <td>Hold Reason</td>
                                    <td>{{ $tracking->hold_reason }} </td>
                                </tr>
                            @endif

                            <tr>
                                <td>Date Sent</td>
                                <td>{{ $tracking->date_sent->format('m/d/Y') }}</td>
                            </tr>

                            <tr>
                                <td>Date Expected</td>
                                <td>{{ $tracking->date_expected->format('m/d/Y') }}</td>
                            </tr>

                            <tr>
                                <td>Progress</td>
                                <td>{{ $tracking->progress }}% </td>
                            </tr>

                            <tr>
                                <td>Current Location</td>
                                <td>{{ $tracking->current_location }} </td>
                            </tr>
                        </tbody>
                    </table>
                </div>


                <div class="row mt-4">
                    <div class="col-md-6 mb-3">
                        <span class="fw-bold">Sender Details:</span>
                        <h5 class="fw-bold mt-2">{{ $shipment->sender_name }}</h5>
                        <address>
                            <p>
                                <span>{{ $shipment->sender_address }}</span><br><br>
                                <span title="Phone" class="text-dark fw-bold">Phone:
                                </span><span>{{ $shipment->sender_phone }}</span><br>
                                <span title="Phone" class="text-dark fw-bold">Email:
                                </span><span>{{ $shipment->sender_email }}</span><br>
                                <span title="Phone" class="text-dark fw-bold">Country:
                                </span><span>{{ $shipment->sender_country }}</span><br>
                            </p>
                        </address>
                    </div>

                    <div class="col-md-6 mb-3">
                        <span class="fw-bold">Receiver Details:</span>
                        <h5 class="fw-bold mt-2">{{ $shipment->receiver_name }}</h5>
                        <address>
                            <p>
                                <span>{{ $shipment->receiver_address }}</span><br><br>
                                <span title="Phone" class="text-dark fw-bold">Phone:
                                </span><span>{{ $shipment->receiver_phone }}</span><br>
                                <span title="Phone" class="text-dark fw-bold">Email:
                                </span><span>{{ $shipment->receiver_email }}</span><br>
                                <span title="Phone" class="text-dark fw-bold">Country:
                                </span><span>{{ $shipment->receiver_country }}</span><br>
                            </p>
                        </address>
                    </div>
                </div>

                <div class="d-flex justify-content-end mt-5">
                    <div class="text-end">
                        <h5 class="fw-bold mt-3"><span class="ms-1">Grand Total:
                            </span><span>{{ $settings->currency . number_format($shipment->amount, 2) }}</span>
                        </h5>
                    </div>
                </div>

                <div class="border-top my-3"></div>

                <div class="row" x-data>
                    <div class="col-xl-6 col-sm-12 col-md-12 mb-3" x-data="{ show_action: false }">
                        <button class="btn btn-primary" @click="show_action=!show_action">
                            <i class="feather icon-box"></i>
                            Actions
                            <i class="feather" :class="!show_action ? 'icon-chevron-right' : 'icon-chevron-left'"></i>
                        </button>

                        <button class="btn btn-info" x-show="show_action" x-cloak
                            x-transition:enter="animate__animated animate__bounceInRight"
                            x-transition:leave="animate__animated animate__bounceOutLeft" data-bs-toggle="modal"
                            data-bs-target="#edit-tracking">
                            <i class="feather icon-edit"></i> Edit
                        </button>

                        <button class="btn btn-info" x-show="show_action" x-cloak
                            x-transition:enter="animate__animated animate__bounceInRight"
                            x-transition:leave="animate__animated animate__bounceOutLeft" data-bs-toggle="modal"
                            data-bs-target="#send-email">
                            <i class="feather icon-mail"></i> Send Email to Shipment Receiver
                        </button>
                    </div>

                    <div class="col-xl-6 col-sm-12 col-md-12 text-end" x-data="invoice" x-init="tracking_code = @js($shipment->tracking_code)">
                        <button class="btn btn-info" @click="download" :disabled="processing">
                            <i class="la-file-pdf la"></i> Download
                        </button>

                        <button class="btn btn-info" @click="stream">
                            <i class="la-file-pdf la"></i> Stream
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('partials.tracking.edit-modal')
    @include('partials.email-modal')

    @if (session('success'))
        <script>
            toast.success(@js(session('success')))
        </script>
    @endif
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
</x-layouts.dashboard>
