<x-layouts.dashboard title="Dashboard">
    <div class="row">

        <div class="col-lg-9">
            <div class="row">

                <div class="col-md-4">
                    <x-widgets.info-card title="Total Shipments" :info="count($total)" />
                </div>

                <div class="col-md-4">
                    <x-widgets.info-card title="Active Shipments" :info="count($active)" />
                </div>

                <div class="col-md-4">
                    <x-widgets.info-card title="Inactive Shipments" :info="count($inactive)" />
                </div>

                <div class="col-md-4">
                    <x-widgets.info-card title="Held Shipments" :info="count(trackings(0))" />
                </div>

                <div class="col-md-4">
                    <x-widgets.info-card title="Shipments Order Placed" :info="count(trackings(1))" />
                </div>

                <div class="col-md-4">
                    <x-widgets.info-card title="In-processing Shipments" :info="count(trackings(2))" />
                </div>

                <div class="col-md-4">
                    <x-widgets.info-card title="Shipped Shipments" :info="count(trackings(3))" />
                </div>

                <div class="col-md-4">
                    <x-widgets.info-card title="Delivered Shipments" :info="count(trackings(4))" />
                </div>

                <div class="col-md-4">
                    <x-widgets.info-card title="Picked up Shipments" :info="count(trackings(5))" />
                </div>
            </div>
        </div>

        <div class="col-lg-3">
            <div class="card">
                <div class="card-body" x-data="{ show_more: false }">
                    <div class="text-muted mb-2">Revenue</div>
                    <h3>{{ $settings->currency . number_format($total_revenue, 2) }}</h3>
                    <span class="text-muted fw-semibold">Total</span>

                    <x-widgets.revenue-info status_code=0 revenue="Held" />
                    <x-widgets.revenue-info status_code=1 revenue="Placed orders" />
                    <x-widgets.revenue-info status_code=2 revenue="Processings" />

                    <div class="text-center mt-2" x-show="!show_more">
                        <span class="badge bg-primary" role="button" @click="show_more=!show_more">Show more</span>
                    </div>

                    <div x-show="show_more" x-cloak x-transition>
                        <x-widgets.revenue-info status_code=3 revenue="Shipped" />
                        <x-widgets.revenue-info status_code=4 revenue="Delivered" />
                        <x-widgets.revenue-info status_code=5 revenue="Picked up" />

                        <div class="text-center mt-2" x-show="show_more">
                            <span class="badge bg-primary" role="button" @click="show_more=!show_more">Show
                                less</span>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        
        @includeUnless(count($active)==0, 'partials.dashboard-charts', ['some' => 'data'])

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <h4 class="mb-0">Recent Shipments</h4>
                            <a class="btn btn-outline-secondary btn-sm" href="{{ route('shipments') }}"
                                wire:navigate>All Shipments</a>
                        </div>
                        <div class="table-responsive">
                            @include('partials.shipment-table', ['shipments' => $recent_shipments])
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-layouts.dashboard>
