import Toastify from 'toastify-js'
import "toastify-js/src/toastify.css"

const defaultConfig = {
    newWindow: true,
    close: false,
    gravity: 'top',
    stopOnFocus: true,
    style: {
        background: '#ffffff',
        color: 'black'
    },
}
const toast = {
    success(text, destination = null, position = "center", duration = 3000) {
        Toastify({
            ...defaultConfig,
            text,
            position,
            destination,
            duration,
            avatar : '/assets/images/avatars/success.png',
        }).showToast();
    },

    error(text, destination = null, position = "center", duration = 3000) {
        Toastify({
            ...defaultConfig,
            text,
            position,
            destination,
            duration,
            avatar : '/assets/images/avatars/error.png',
        }).showToast();
    },

    info(text, destination = null, position = "center", duration = 500) {
        Toastify({
            ...defaultConfig,
            text,
            position,
            destination,
            duration,
            avatar : '/assets/images/avatars/info.png',
        }).showToast();
    },

    fallback() {
        return this.error('Something went wrong, please try again later.')
    }
}

export default toast