<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('site_name')->nullable();
            $table->string('site_url')->nullable();
            $table->string('site_domain')->nullable();
            $table->string('site_email')->nullable();
            $table->string('site_address')->nullable();
            $table->string('site_phone')->nullable();
            $table->string('live_chat')->nullable();
            $table->string('site_logo')->default('/home-assets/images/logo.png');
            $table->string('site_alt_logo')->default('/home-assets/images/logo-2.png');
            $table->string('site_favicon')->default('/home-assets/images/favicon.png');
            $table->string('currency')->default('$');
            $table->string('weight_unit')->default('KG');
            $table->string('email_config')->nullable();
            $table->boolean('updated')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
