<?php

use App\Models\Setting;
use App\Models\Shipment;
use App\Models\Tracking;

function tracking_code($length = 10) {
    $capitalLetters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $capitalLetters[rand(0, strlen($capitalLetters) - 1)];
    }

    return $randomString;
}

function trackings($status_code) {
    return Tracking::where('status_code', $status_code)->get();
}

function status_percent($status_code) {
    $total = Shipment::sum('amount');
    $shipmentTrackingJoin = Shipment::join('trackings', 'trackings.shipment_id', '=', 'shipments.id');
    $status_sum = $shipmentTrackingJoin->where('trackings.status_code', $status_code)->sum('amount');
    if($total != 0) {
        $percent = ($status_sum / $total) * 100;
        return number_format($percent, 2);
    }
    return 0;
}

function revenue($status_code) {
    $shipmentTrackingJoin = Shipment::join('trackings', 'trackings.shipment_id', '=', 'shipments.id');
    return $shipmentTrackingJoin->where('trackings.status_code', $status_code)->sum('amount');
}

function populate() {
    $shipment = Shipment::create([
        'admin_id' => 1,
        'sender_name' => fake()->name,
        'sender_email' => fake()->unique()->safeEmail,
        'sender_country' => fake()->country,
        'sender_address' => fake()->address,
        'sender_phone' => fake()->phoneNumber,
        'receiver_name' => fake()->name,
        'receiver_email' => fake()->unique()->safeEmail,
        'receiver_country' => fake()->country,
        'receiver_address' => fake()->address,
        'receiver_phone' => fake()->phoneNumber,
        'amount' => fake()->randomNumber(4),
        'description' => fake()->sentence,
        'weight' => fake()->randomNumber(2),
        'photo' => fake()->imageUrl(640, 480),
        'is_active' => 1,
        'tracking_code' => tracking_code(),
    ]);

    Tracking::create([
        'shipment_id' => $shipment->id,
        'date_sent' => now(),
        'date_expected' => now()->addDays(7),
        'progress' => 0,
        'current_location' => fake()->country,
        'status_code' => fake()->numberBetween(0, 5),
    ]);
}

function status($status_code) {
    switch ($status_code) {
        case 0:
            return 'Held';
            break;

        case 1:
            return 'Order&nbsp;placed';
            break;

        case 2:
            return 'Processing';
            break;
            
        case 3:
            return 'Shipped';
            break;
        
        case 4:
            return 'Delivered';
            break;

        case 5:
            return 'Picked&nbsp;Up';
            break;
        default:
            # code...
            break;
    }
}


function status_class($status_code) {
    switch ($status_code) {
        case 0:
            return 'danger';
            break;

        case 1:
            return 'primary';
            break;

        case 2:
            return 'warning';
            break;
            
        case 3:
            return 'info';
            break;
        
        case 4:
            return 'success';
            break;

        case 5:
            return 'dark';
            break;

        default:
            # code...
            break;
    }
}

function shipment_status($is_active) {
    return ($is_active == '1') ? 'Active' : 'Inactive';
}

function settings() {
    return Setting::find(1);
}