<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tracking extends Model
{
    use HasFactory;

    protected $guarded = [];
    
    public static function active() {
        return parent::where('is_active', true);
    }

    public function shipment() {
        return $this->belongsTo(Shipment::class);
    }

    protected $casts = [
        'date_sent' => 'datetime',
        'date_expected' => 'datetime',
    ];
}
