<?php

namespace App\Livewire\Auth;

use Livewire\Attributes\Validate;
use Livewire\Component;

class Login extends Component
{
    #[Validate('required')]
    public $email;

    #[Validate('required')]
    public $password;

    public $remember = false;

    public function login() {
        $this->validate();

        $credentials = [
            'email' => $this->email,
            'password' => $this->password,
        ];

        if(auth()->attempt($credentials, $this->remember)) {
            return $this->redirect(route('dashboard'), navigate: true);
        } else {
            $this->addError('email', 'Invalid credentials.');
        }
    }
}
