<?php

namespace App\Livewire\Admin;

use App\Models\Admin;
use Illuminate\Support\Facades\Hash;
use Livewire\Attributes\Validate;
use Livewire\Component;

class Profile extends Component
{
    #[Validate('required|max:255')]
    public $name;

    #[Validate('required|email|max:255')]
    public $email;

    #[Validate('nullable|max:255')]
    public $password;


    public function render() {
        return view('livewire.admin.profile');
    }

    public function mount() {
        $admin = Admin::find(auth()->id());
        $this->name = $admin->name;
        $this->email = $admin->email;
    }

    public function update() {
        $this->validate();
        $admin = Admin::find(auth()->id());

        $this->password = $this->password ? $this->password: $admin->password;
        $admin->update($this->all());
        $this->password = '';
        
        $this->dispatch('profile-updated', 'Profile updated successfully.');
    }
}
