<?php

namespace App\Http\Controllers\Admin;

use App\Models\Shipment;
use App\Http\Controllers\Controller;
use Barryvdh\DomPDF\PDF;

class ShipmentController extends Controller
{
    public function all() {
        $shipments = Shipment::latest()->get();
        $single_shipment = Shipment::first();
        return view('admin.shipment.all', compact('shipments', 'single_shipment'));
    }

    public function create() {
        return view('admin.shipment.create');
    }

    public function single(Shipment $shipment) {
        return view('admin.shipment.single', compact('shipment'));
    }

    public function edit(Shipment $shipment) {
        return view('admin.shipment.edit', compact('shipment'));
    }

    public function delete(Shipment $shipment) {
        $shipment->tracking()->delete();
        $shipment->delete();

        $success_message = 'Shipment and associated tracking deleted successfully.';
        session()->flash('success', $success_message);
        return response()->json(['success' => $success_message]);
    }
}
