<?php

namespace App\Http\Controllers\Admin;

use App\Models\Shipment;
use Barryvdh\DomPDF\PDF;
use App\Http\Controllers\Controller;

class InvoiceController extends Controller
{
    public function stream(Shipment $shipment, PDF $pdf) {
        $tracking = $shipment->tracking;
        $pdf->loadView('admin.shipment.invoice', compact('shipment', 'tracking'));
        return $pdf->stream();
    }

    public function download(Shipment $shipment, PDF $pdf) {
        $tracking = $shipment->tracking;
        
        $file_url = "shipment_invoice/Shipment Invoice - {$shipment->tracking_code}.pdf";
        $download_url = url('/storage/'.$file_url);

        $pdf->loadView('admin.shipment.invoice', compact('shipment', 'tracking'))->save($file_url, 'public');
        return response()->json(['success' => true, 'download_url' => $download_url]);
    }
}
